(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15058,        582]*)
(*NotebookOutlinePosition[     15989,        613]*)
(*  CellTagsIndexPosition[     15945,        609]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Constant Coefficients Vector Systems:\n",
  StyleBox["Nonhomogeneous Case",
    FontSize->14],
  ""
}], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "We now take the second step in the solution of first order constant \
coefficient vector systems of the form ",
  StyleBox["Y'[x]-A.Y[x]==Q[x]",
    FontWeight->"Bold"],
  ".  Here ",
  StyleBox["Y[x]",
    FontWeight->"Bold"],
  " is an n-vector, ",
  StyleBox["A",
    FontWeight->"Bold"],
  " is a constant nXn matrix and ",
  StyleBox["Q[x]",
    FontWeight->"Bold"],
  " is an nXn vector of continuous functions defined on an interval ",
  StyleBox["I: [a, b]",
    FontWeight->"Bold"],
  " of the reals. The critical ideas are:\n\[Bullet]  matrix ",
  StyleBox["characteristic value problems;",
    FontVariations->{"Underline"->True}],
  "\n\[Bullet]  ",
  StyleBox["Fundamental sets",
    FontVariations->{"Underline"->True}],
  " of vectors of functions; and\n\[Bullet]  ",
  StyleBox["Variation of Parameters",
    FontVariations->{"Underline"->True}],
  ".\nWhen the matrix  A  admits a complete system of characteristic vectors \
(A is diagonalizable), our theory was simple:  we used the built-in function \
",
  StyleBox["Eigensystem",
    FontWeight->"Bold"],
  ". The homogeneous case was done in the last notebook. ",
  StyleBox["We now do the the nonhomogeneous case",
    FontVariations->{"Underline"->True}],
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The Theory"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The Kernel"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "The Kernel was found in the last notebook by solving the characteristic \
value problem for the coefficient matrix. We returned the Kernel as an nXn \
invertible matrix ",
  StyleBox["W[x]",
    FontWeight->"Bold"],
  ", the Wronskian Matrix. This Wronskian matrix satisfies the equation ",
  StyleBox["W'[x]-A.W[x]==0",
    FontWeight->"Bold"],
  ". The function ",
  StyleBox["FundamentalMatrix",
    FontWeight->"Bold"],
  " introduced in that notebook is reproduced below in the initialization \
cells."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"The Particular Solution by Variation of Parameters"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Having solved the homogeneous equation for the fundamental matrix ",
  StyleBox["W[x]",
    FontWeight->"Bold"],
  ", we assume a solution of  ",
  StyleBox["Y'[x]-A.Y[x]==Q[x]",
    FontWeight->"Bold"],
  " having the form ",
  StyleBox["Y[x]=W[x].V[x]",
    FontWeight->"Bold"],
  ", where ",
  StyleBox["V[x]",
    FontWeight->"Bold"],
  " is a column vector of continuously differentiable  functions. To see how \
the nonhomogeneous equation is solved, observe that the following calculation \
holds:\n",
  StyleBox[
  "Y'[x]-A.Y[x]==W'[x].V[x]+W[x].V'[x]-A.W[x].V[x]==\n\
A.W[x].V[x]+W[x].V'[x]-A.W[x].V[x]==W[x].V'[x]==Q[x].\n",
    FontWeight->"Bold"],
  "So we see that ",
  StyleBox["V'[x]==Inverse[W[x]].Q[x]",
    FontWeight->"Bold"],
  ", and hence that \n",
  StyleBox["V[x]=Integrate[Inverse[W[x]].Q[x],x]",
    FontWeight->"Bold"],
  ".\nThus our particular solution is ",
  StyleBox["Yp[x]=W[x].Integrate[Inverse[W[x]].Q[x],x]",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Complete Solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Having both ",
  StyleBox["W[x]",
    FontWeight->"Bold"],
  " and ",
  StyleBox["Yp[x]",
    FontWeight->"Bold"],
  " lets us write the complete solution as ",
  StyleBox["Y[x]=W[x].K+Yp[x]",
    FontWeight->"Bold"],
  ", where ",
  StyleBox["K",
    FontWeight->"Bold"],
  " is a constant vector.  We are now in a position to apply any initial or \
boundary conditions which we have been given."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["How to Do It"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData[
"The Characteristic Equation for Matrix A has Distinct Real Roots"], 
  "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Solve ",
  StyleBox["Y'[x]-A.Y[x]==0",
    FontWeight->"Bold"],
  ", where:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = {{\(-1\), 1}, {2, 0}}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\(-1\), 1}, {2, 0}}\)], "Output"]
}, Closed]],

Cell[TextData["and"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Q[x_] = {1, x}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1, x}\)], "Output"]
}, Closed]],

Cell[TextData["Get the Wronskian matrix:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(W[x] = FundamentalMatrix[A, x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\(-\[ExponentialE]\^\(\(-2\)\ x\)\), \[ExponentialE]\^x}, {\
\[ExponentialE]\^\(\(-2\)\ x\), 2\ \[ExponentialE]\^x}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Yp[x_] = 
      Simplify[W[
            x] . \(\[Integral]Inverse[W[x]] . 
                Q[x] \[DifferentialD]x\)]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1\/4\ \((\(-1\) - 2\ x)\), 1\/4\ \((\(-7\) - 2\ x)\)}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Y[x_] = W[x] . {K1, K2} + Yp[x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(-\[ExponentialE]\^\(\(-2\)\ x\)\)\ K1 + \[ExponentialE]\^x\ K2 + 
        1\/4\ \((\(-1\) - 2\ x)\), \[ExponentialE]\^\(\(-2\)\ x\)\ K1 + 
        2\ \[ExponentialE]\^x\ K2 + 1\/4\ \((\(-7\) - 2\ x)\)}\)], "Output"]
}, Closed]],

Cell[TextData[
"We can now apply other conditions which we have. Let's verify that we have a \
solution:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["Y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "-", \(A . Y[x]\)}], 
        "==", \(Q[x]\)}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"The Characteristic Equation for Matrix A has Complex Roots"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[A, Y, W, Yp, x]\)], "Input",
  AspectRatioFixed->False],

Cell[TextData[{
  "Solve ",
  StyleBox["Y'[x]-A.Y[x]==Q[x]",
    FontWeight->"Bold"],
  ", where:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = {{1, \(-2\)}, {5, \(-1\)}}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{1, \(-2\)}, {5, \(-1\)}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Q[x_] = {1, x}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1, x}\)], "Output"]
}, Closed]],

Cell[TextData["Get the Wronskian matrix:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(W[x_] = FundamentalMatrix[A, x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\((1 - 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ \
x\), \((1 + 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)}, \
{5\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ x\), 
        5\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Yp[x_] = 
      Simplify[W[
            x] . \(\[Integral]Inverse[W[x]] . 
                Q[x] \[DifferentialD]x\)]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1\/9\ \((1 - 2\ x)\), \(6 - x\)\/9}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Y[x_] = W[x] . {K1, K2} + Yp[x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\((1 - 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ \
x\)\ K1 + \((1 + 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)\ \
K2 + 1\/9\ \((1 - 2\ x)\), 
      5\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ x\)\ K1 + 
        5\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)\ K2 + \(6 - x\)\/9}\)], \
"Output"]
}, Closed]],

Cell[TextData[
"We can now apply other conditions which we have. Let's verify that we have a \
solution:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["Y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "-", \(A . Y[x]\)}], 
        "==", \(Q[x]\)}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Automate the Process"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Once again, we collect the above steps into a function:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(CompleteSolution[a_, Q_, Y_, x_] := 
      Block[{W, Yp, i}, W[x] = FundamentalMatrix[a, x]; 
        Yp[x] = Simplify[
            W[x] . \(\[Integral]Inverse[W[x]] . Q[x] \[DifferentialD]x\)]; 
        W[x] . Table[c[i], {i, Length[W[x]]}] + Yp[x]]\)], "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Use ",
  StyleBox["CompleteSolution",
    FontWeight->"Bold"],
  " to solve the two examples above, where:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Q[x_] = {1, x}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1, x}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example1"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Y[x_] = CompleteSolution[{{\(-1\), 1}, {2, 0}}, Q, Y, x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1\/4\ \((\(-1\) - 2\ x)\) - \[ExponentialE]\^\(\(-2\)\ x\)\ c[
            1] + \[ExponentialE]\^x\ c[2], 
      1\/4\ \((\(-7\) - 2\ x)\) + \[ExponentialE]\^\(\(-2\)\ x\)\ c[1] + 
        2\ \[ExponentialE]\^x\ c[2]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["Y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "-", \({{\(-1\), 1}, {2, 0}} . Y[x]\)}], "==", \(Q[x]\)}], 
      "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example2"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Y[x_] = 
      CompleteSolution[{{1, \(-2\)}, {5, \(-1\)}}, Q, Y, x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1\/9\ \((1 - 2\ x)\) + \((1 - 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ \
x\)\ c[1] + \((1 + 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)\ \
c[2], \(6 - x\)\/9 + 5\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ x\)\ c[1] + 
        5\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)\ c[2]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["Y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "-", \({{1, \(-2\)}, {5, \(-1\)}} . Y[x]\)}], "==", \(Q[x]\)}], 
      "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["For Further Thought"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Try to solve several initial value problems and boundary value problems for \
the two examples above."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Initialization"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Needs["\<Algebra`ReIm`\>"]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(FundamentalMatrix[A_, x_] := 
      Block[{roots, vectors, exponentials}, {roots, vectors} = 
          Eigensystem[A]; exponentials = \((Exp[#1\ x] &)\)[roots]; 
        Transpose[vectors\ exponentials]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{536, 661},
WindowMargins->{{54, Automatic}, {Automatic, 10}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 183, 7, 95, "Subtitle",
  Evaluatable->False],
Cell[1962, 62, 1349, 38, 176, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3336, 104, 88, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3449, 110, 91, 2, 70, "Subsection"],
Cell[3543, 114, 587, 16, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[4167, 135, 132, 3, 70, "Subsection"],
Cell[4302, 140, 1055, 32, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[5394, 177, 102, 2, 70, "Subsection"],
Cell[5499, 181, 477, 17, 70, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6025, 204, 90, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6140, 210, 149, 4, 46, "Subsection",
  Evaluatable->False],
Cell[6292, 216, 156, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6473, 227, 85, 2, 27, "Input"],
Cell[6561, 231, 55, 1, 27, "Output"]
}, Closed]],
Cell[6631, 235, 78, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6734, 241, 74, 2, 27, "Input"],
Cell[6811, 245, 40, 1, 27, "Output"]
}, Closed]],
Cell[6866, 249, 100, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6991, 255, 90, 2, 27, "Input"],
Cell[7084, 259, 152, 2, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7273, 266, 176, 5, 41, "Input"],
Cell[7452, 273, 88, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7577, 279, 91, 2, 27, "Input"],
Cell[7671, 283, 238, 3, 42, "Output"]
}, Closed]],
Cell[7924, 289, 164, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8113, 297, 287, 8, 27, "Input"],
Cell[8403, 307, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8490, 314, 140, 3, 46, "Subsection",
  Evaluatable->False],
Cell[8633, 319, 81, 2, 27, "Input"],
Cell[8717, 323, 159, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8901, 334, 90, 2, 27, "Input"],
Cell[8994, 338, 60, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9091, 344, 74, 2, 27, "Input"],
Cell[9168, 348, 40, 1, 27, "Output"]
}, Closed]],
Cell[9223, 352, 100, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9348, 358, 91, 2, 27, "Input"],
Cell[9442, 362, 321, 6, 32, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9800, 373, 176, 5, 41, "Input"],
Cell[9979, 380, 70, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10086, 386, 91, 2, 27, "Input"],
Cell[10180, 390, 382, 8, 76, "Output"]
}, Closed]],
Cell[10577, 401, 164, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10766, 409, 287, 8, 27, "Input"],
Cell[11056, 419, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11155, 427, 98, 2, 36, "Section",
  Evaluatable->False],
Cell[11256, 431, 131, 3, 32, "Text",
  Evaluatable->False],
Cell[11390, 436, 310, 6, 98, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[11737, 447, 86, 2, 36, "Section",
  Evaluatable->False],
Cell[11826, 451, 187, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12038, 462, 74, 2, 27, "Input"],
Cell[12115, 466, 40, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[12192, 472, 92, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12309, 478, 116, 2, 27, "Input"],
Cell[12428, 482, 252, 4, 76, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[12717, 491, 316, 9, 27, "Input"],
Cell[13036, 502, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13123, 509, 92, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13240, 515, 128, 3, 27, "Input"],
Cell[13371, 520, 381, 6, 76, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[13789, 531, 321, 9, 27, "Input"],
Cell[14113, 542, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14212, 550, 97, 2, 36, "Section",
  Evaluatable->False],
Cell[14312, 554, 177, 4, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[14526, 563, 92, 2, 36, "Section",
  Evaluatable->False],
Cell[14621, 567, 114, 3, 27, "Input",
  InitializationCell->True],
Cell[14738, 572, 292, 6, 91, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

